#include "RegisterMaterialsInteractionsCommand.h"
#include "../DataTypes/DataString.h"
namespace SimulationEngine
{

RegisterMaterialsInteractionsCommand::RegisterMaterialsInteractionsCommand():ICommand(ConfigurationServer::GetInstance()->GetCommandRegisterMaterialsInteractionsKey())
{
}

RegisterMaterialsInteractionsCommand::~RegisterMaterialsInteractionsCommand()
{
}

list<DataParameter*> RegisterMaterialsInteractionsCommand::execute(list <DataParameter *> pars)
{
	std::list<DataParameter *>::iterator iter;	
	iter = pars.begin();
	while (iter!=pars.end())
	{
		if (DataMaterial *datamaterial = dynamic_cast<DataMaterial *> ((*iter)))
		{
			MaterialManager::GetInstance()->RegisterMaterial(*datamaterial);
		}
		else if (DataMaterialInteraction *datamaterialinteraction = dynamic_cast<DataMaterialInteraction *> ((*iter)))
		{
			MaterialManager::GetInstance()->RegisterInteraction(datamaterialinteraction->GetMaterial1(), datamaterialinteraction->GetMaterial2(), datamaterialinteraction->GetInteraction());
		} 
		
		iter++;
	}
	list<DataParameter *> ret; //empty list
	ret.push_back(new DataString("Successfully created materials and interactions"));
	return ret;
}

}
